﻿using System;

namespace HalloWereld
{
    class Program
    {
        public enum BtwPercentage { Verlegd = 0, Laag = 9, Hoog = 21, Onbekend = -1 }

        static void Main(string[] args)
        {
            Console.WriteLine("Wilt u BTW berekenen of inches omzetten naar centimeter?");
            Console.WriteLine("Kies btw of inch:");
            string invoer = Console.ReadLine().ToLower();
            if (invoer == "btw")
            {
                Console.WriteLine("Kies verlegd, hoog of laag:");
                invoer = Console.ReadLine().ToLower();
                BtwPercentage percentage = BtwPercentage.Onbekend;
                switch (invoer)
                {
                    case "verlegd":
                        percentage = BtwPercentage.Verlegd;
                        break;
                    case "laag":
                        percentage = BtwPercentage.Laag;
                        break;
                    case "hoog":
                        percentage = BtwPercentage.Hoog;
                        break;
                }
                if (percentage != BtwPercentage.Onbekend)
                {
                    Console.WriteLine("Voer het bedrag in:");
                    invoer = Console.ReadLine();
                    float bedrag = 0;
                    var gelukt = Single.TryParse(invoer, out bedrag);
                    var btw = HoeveelBTW(bedrag, percentage);
                    Console.WriteLine($"{(int)percentage}% BTW over {bedrag} is {btw}.");
                }
                else
                {
                    Console.WriteLine("Uw invoer is ongeldig.");
                }
            }
            else if (invoer == "inch")
            {
                Console.WriteLine("Voer het aantal inch in:");
                invoer = Console.ReadLine();
                float inch = 0;
                var gelukt = Single.TryParse(invoer, out inch);
                var centimeter = HoeveelCentimeter(inch);
                Console.WriteLine($"Er gaat {centimeter} cm in {inch} inch");
            }
            else
            {
                Console.WriteLine("Uw invoer is ongeldig.");
            }
        }

        static float HoeveelBTW(float bedrag, BtwPercentage percentage)
        {
            float btw = bedrag / 100 * (int)percentage;
            return btw;
        }

        static float HoeveelCentimeter(float inch)
        {
            const float centimeterPerInch = 2.54F;
            var centimeter = inch * centimeterPerInch;
            return centimeter;
        }
    }
}
